<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect(route('login'));
});

//Clear Cache
        Route::get('/route-cache', function() { $exitCode = Artisan::call('route:cache');
        return 'Routes cache cleared';
        });
 
        Route::get('/config-cache', function() {$exitCode = Artisan::call('config:cache');
        return 'Config cache cleared';
        });
 
        Route::get('/clear-cache', function() {$exitCode = Artisan::call('cache:clear');
        return 'Application cache cleared';
        });
 
        Route::get('/view-clear', function() {$exitCode = Artisan::call('view:clear');
        return 'View cache cleared';
        });

Route::get('/api/verify/{id}', 'VerifyController@checkerStud');
Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

Auth::routes(['verify' => true]);

Route::post('/logout', 'Auth\LoginController@logout')->name('staff.logout');

Route::get('/home', 'HomeController@index')->middleware('verified');

Route::group(['middleware' => ['auth']], function() {
    Route::post('/changepassword', 'UserController@change_password')->name('changepassword.update');
    Route::post('import', 'UserController@import')->name('admin.users.import');
    Route::post('uploadusers', 'UserController@upload')->name('admin.users.upload');
    Route::get('export', 'UserController@export')->name('admin.users.export');
    Route::resource('/users','UserController');

    Route::post('import', 'ResultController@import')->name('admin.results.import');
    Route::get('/studentdashboard', 'ResultController@student_dashboard')->name('student.dashboard');
    Route::get('/resultsmanage', 'ResultController@manage_results')->name('admin.result.manage');
    Route::get('/session/{session}/semester/{semester}', 'ResultController@show')->name('result.show');
    Route::get('/admindashboard', 'ResultController@admin_dashboard')->name('admin.dashboard');
    Route::get('/uploadresultsindex', 'ResultController@uploadindex')->name('admin.result.upload');
    Route::get('/loadfaculties', 'ResultController@loadFaculties')->name('faculties.load');
    Route::get('/loaddepartments', 'ResultController@get_departments')->name('departments.load');
    Route::post('/loadprogrammetypes', 'ResultController@loadProgrammeTypes')->name('programmetypes.load');
    Route::post('/loadprogrammes', 'ResultController@get_programmes')->name('programmes.load');
    Route::post('/uploadresultscreate', 'ResultController@import')->name('admin.result.create');
    Route::get('/loadsessions', 'ResultController@filter_sessions')->name('sessions.load');
    Route::post('/changeresultstatus', 'ResultController@change_result_status')->name('result.status.change');

    Route::Resource('/posts', 'PostController');
    Route::post('/comment/store', 'CommentController@store')->name('comments.store');
});

